<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/form_helper.html form_helper}.
*
* @package direct-as-a-service
* @subpackage helpers
* @filesource
*//** */


/**
 * Hidden Input Field
 *
 * Generates hidden fields.  You can pass a simple key/value string or an associative
 * array with multiple values.
 *
 * @access	public
 * @param	mixed
 * @param	string
 * @return	string
 */
 
if ( ! function_exists('form_hidden'))
{
	function form_hidden($name, $value = '', $id = FALSE, $recursing = FALSE)
	{
		static $form;

		if ($recursing === FALSE)
		{
			$form = "\n";
		}

		if (is_array($name))
		{
			foreach ($name as $key => $val)
			{
				//if first param is array, and second is TRUE, assume we want the name to also be the id
				if($value === TRUE) { form_hidden($key, $val, $key, TRUE); }
				//otherwise no id attribute will be added to these form elements
				else { form_hidden($key, $val, FALSE, TRUE); }
			}
			return $form;
		}

		if ( ! is_array($value))
		{
			if($id === FALSE || strlen(trim($id)) <= 0) { $form .= '<input type="hidden" name="'.$name.'" value="'.form_prep($value, $name).'" />'."\n"; }
			else { $form .= '<input type="hidden" name="'.$name.'" id="'.$id.'" value="'.form_prep($value, $name).'" />'."\n"; }
		}
		else
		{
			foreach ($value as $k => $v)
			{
				$k = (is_int($k)) ? '' : $k;
				form_hidden($name.'['.$k.']', $v, $id, TRUE);
			}
		}

		return $form;
	}
}